/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2216;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.Status;
import ibm.nways.jdm2216.AtmAdapterImage;
import ibm.nways.jdm2216.EIA232AdapterImage;
import ibm.nways.jdm2216.EmptyAdapterImage;
import ibm.nways.jdm2216.EsconAdapterImage;
import ibm.nways.jdm2216.EthernetAdapterImage;
import ibm.nways.jdm2216.FastEthernetAdapterImage;
import ibm.nways.jdm2216.Fddi1AdapterImage;
import ibm.nways.jdm2216.GraphicImageModule;
import ibm.nways.jdm2216.HssiAdapterImage;
import ibm.nways.jdm2216.IsdnE1AdapterImage;
import ibm.nways.jdm2216.IsdnT1AdapterImage;
import ibm.nways.jdm2216.TokenRingAdapterImage;
import ibm.nways.jdm2216.UnknownAdapterImage;
import ibm.nways.jdm2216.V35AdapterImage;
import ibm.nways.jdm2216.X21AdapterImage;
import java.awt.Point;

class GraphicSlotContainer
extends GraphicContainer {
    private static final int slotCount = 8;
    private Point[] slotPoints;
    JdmBrowser browser;
    GraphicImageModule[] slots;
    Point boxPoint;

    GraphicSlotContainer(JdmBrowser jdmBrowser, Point point) {
        this.browser = jdmBrowser;
        this.slots = new GraphicImageModule[8];
        int n = 182 + point.x;
        int n2 = 19 + point.y;
        int n3 = 171;
        int n4 = 28;
        this.slotPoints = new Point[8];
        int n5 = 0;
        while (n5 < 4) {
            this.slotPoints[n5] = new Point(n5 * n4, 0);
            ++n5;
        }
        int n6 = 4;
        while (n6 < 8) {
            this.slotPoints[n6] = new Point((n6 - 4) * n4, n3);
            ++n6;
        }
        int n7 = 0;
        while (n7 < 8) {
            this.slots[n7] = null;
            ++n7;
        }
        this.setLocation(n, n2);
        this.setVisible(false);
    }

    public void showCards() {
        this.setVisible(false);
        int n = 0;
        while (n < this.slots.length) {
            if (this.slots[n] == null) {
                this.addSlot(n + 1, new EmptyAdapterImage(this.browser, this.slotPoints[n]));
            }
            ++n;
        }
        this.setSize(this.getPreferredSize());
        this.setVisible(true);
    }

    public void addSlot(int n, int n2, Status status, GraphicActionNavigate graphicActionNavigate, int n3) {
        boolean bl = false;
        try {
            switch (n3) {
                case 3: {
                    if (this.slots[n - 1] == null) {
                        TokenRingAdapterImage tokenRingAdapterImage = new TokenRingAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, tokenRingAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof TokenRingAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (this.slots[n - 1] == null) {
                        EthernetAdapterImage ethernetAdapterImage = new EthernetAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, ethernetAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof EthernetAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 10: {
                    if (this.slots[n - 1] == null) {
                        AtmAdapterImage atmAdapterImage = new AtmAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, atmAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof AtmAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (this.slots[n - 1] == null) {
                        IsdnT1AdapterImage isdnT1AdapterImage = new IsdnT1AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, isdnT1AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof IsdnT1AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (this.slots[n - 1] == null || this.slots[n - 1] instanceof IsdnT1AdapterImage) {
                        IsdnE1AdapterImage isdnE1AdapterImage = new IsdnE1AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, isdnE1AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof IsdnE1AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 6: {
                    if (this.slots[n - 1] instanceof UnknownAdapterImage) {
                        X21AdapterImage x21AdapterImage = new X21AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.copyStatusFromAggregate(x21AdapterImage, this.slots[n - 1]);
                        this.addSlot(n, x21AdapterImage);
                    } else if (this.slots[n - 1] == null) {
                        X21AdapterImage x21AdapterImage = new X21AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, x21AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof X21AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 7: {
                    if (this.slots[n - 1] instanceof UnknownAdapterImage) {
                        EIA232AdapterImage eIA232AdapterImage = new EIA232AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.copyStatusFromAggregate(eIA232AdapterImage, this.slots[n - 1]);
                        this.addSlot(n, eIA232AdapterImage);
                    } else if (this.slots[n - 1] == null) {
                        EIA232AdapterImage eIA232AdapterImage = new EIA232AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, eIA232AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof EIA232AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 8: {
                    if (this.slots[n - 1] instanceof UnknownAdapterImage) {
                        V35AdapterImage v35AdapterImage = new V35AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.copyStatusFromAggregate(v35AdapterImage, this.slots[n - 1]);
                        this.addSlot(n, v35AdapterImage);
                    } else if (this.slots[n - 1] == null) {
                        V35AdapterImage v35AdapterImage = new V35AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, v35AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof V35AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 11: {
                    if (this.slots[n - 1] == null) {
                        EsconAdapterImage esconAdapterImage = new EsconAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, esconAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof EsconAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 12: {
                    if (this.slots[n - 1] == null) {
                        Fddi1AdapterImage fddi1AdapterImage = new Fddi1AdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, fddi1AdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof Fddi1AdapterImage)) break;
                    bl = true;
                    break;
                }
                case 14: {
                    if (this.slots[n - 1] == null) {
                        HssiAdapterImage hssiAdapterImage = new HssiAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, hssiAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof HssiAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 15: {
                    if (this.slots[n - 1] == null) {
                        FastEthernetAdapterImage fastEthernetAdapterImage = new FastEthernetAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, fastEthernetAdapterImage);
                    }
                    if (!(this.slots[n - 1] instanceof FastEthernetAdapterImage)) break;
                    bl = true;
                    break;
                }
                case 0: {
                    if (this.slots[n - 1] == null) {
                        UnknownAdapterImage unknownAdapterImage = new UnknownAdapterImage(this.browser, this.slotPoints[n - 1]);
                        this.addSlot(n, unknownAdapterImage);
                    }
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.slots[n - 1].setStatus(n2, status);
                this.slots[n - 1].setAction(n2, graphicActionNavigate);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addSlot(int n, int n2) {
        try {
            switch (n2) {
                case 3: {
                    TokenRingAdapterImage tokenRingAdapterImage = new TokenRingAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, tokenRingAdapterImage);
                    return;
                }
                case 2: {
                    EthernetAdapterImage ethernetAdapterImage = new EthernetAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, ethernetAdapterImage);
                    return;
                }
                case 10: {
                    AtmAdapterImage atmAdapterImage = new AtmAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, atmAdapterImage);
                    return;
                }
                case 4: {
                    IsdnT1AdapterImage isdnT1AdapterImage = new IsdnT1AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, isdnT1AdapterImage);
                    return;
                }
                case 5: {
                    IsdnE1AdapterImage isdnE1AdapterImage = new IsdnE1AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, isdnE1AdapterImage);
                    return;
                }
                case 6: {
                    X21AdapterImage x21AdapterImage = new X21AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, x21AdapterImage);
                    return;
                }
                case 7: {
                    EIA232AdapterImage eIA232AdapterImage = new EIA232AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, eIA232AdapterImage);
                    return;
                }
                case 8: {
                    V35AdapterImage v35AdapterImage = new V35AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, v35AdapterImage);
                    return;
                }
                case 11: {
                    EsconAdapterImage esconAdapterImage = new EsconAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, esconAdapterImage);
                    return;
                }
                case 12: {
                    Fddi1AdapterImage fddi1AdapterImage = new Fddi1AdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, fddi1AdapterImage);
                    return;
                }
                case 14: {
                    HssiAdapterImage hssiAdapterImage = new HssiAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, hssiAdapterImage);
                    return;
                }
                case 15: {
                    FastEthernetAdapterImage fastEthernetAdapterImage = new FastEthernetAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, fastEthernetAdapterImage);
                    return;
                }
                case 0: {
                    UnknownAdapterImage unknownAdapterImage = new UnknownAdapterImage(this.browser, this.slotPoints[n - 1]);
                    this.addSlot(n, unknownAdapterImage);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void addSlot(int n, GraphicImageModule graphicImageModule) {
        if (this.slots[n - 1] != null) {
            this.remove(this.slots[n - 1]);
        }
        this.slots[n - 1] = graphicImageModule;
        this.add(this.slots[n - 1]);
    }

    public void copyStatusFromAggregate(GraphicImageModule graphicImageModule, GraphicImageModule graphicImageModule2) {
        int n = 1;
        while (n <= graphicImageModule.getModuleCount()) {
            Status status = graphicImageModule2.getStatus(n);
            graphicImageModule.setStatus(n, status);
            ++n;
        }
    }
}

